var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { h } from '../../../../base/browser/dom.js';
import { Button } from '../../../../base/browser/ui/button/button.js';
import { Codicon } from '../../../../base/common/codicons.js';
import { Disposable, DisposableStore } from '../../../../base/common/lifecycle.js';
import { autorun, derived, observableFromEvent } from '../../../../base/common/observable.js';
import { globalTransaction, observableValue } from '../../../../base/common/observableInternal/base.js';
import { DiffEditorWidget } from '../diffEditor/diffEditorWidget.js';
import { MenuWorkbenchToolBar } from '../../../../platform/actions/browser/toolbar.js';
import { MenuId } from '../../../../platform/actions/common/actions.js';
import { IInstantiationService } from '../../../../platform/instantiation/common/instantiation.js';
import { ActionRunnerWithContext } from './utils.js';
export class TemplateData {
    constructor(viewModel) {
        this.viewModel = viewModel;
    }
    getId() {
        return this.viewModel;
    }
}
let DiffEditorItemTemplate = class DiffEditorItemTemplate extends Disposable {
    constructor(_container, _overflowWidgetsDomNode, _workbenchUIElementFactory, _instantiationService) {
        super();
        this._container = _container;
        this._overflowWidgetsDomNode = _overflowWidgetsDomNode;
        this._workbenchUIElementFactory = _workbenchUIElementFactory;
        this._instantiationService = _instantiationService;
        this._viewModel = observableValue(this, undefined);
        this._collapsed = derived(this, reader => { var _a; return (_a = this._viewModel.read(reader)) === null || _a === void 0 ? void 0 : _a.collapsed.read(reader); });
        this._contentHeight = observableValue(this, 500);
        this.height = derived(this, reader => {
            const h = this._collapsed.read(reader) ? 0 : this._contentHeight.read(reader);
            return h + this._outerEditorHeight;
        });
        this._modifiedContentWidth = observableValue(this, 0);
        this._modifiedWidth = observableValue(this, 0);
        this._originalContentWidth = observableValue(this, 0);
        this._originalWidth = observableValue(this, 0);
        this.maxScroll = derived(this, reader => {
            const scroll1 = this._modifiedContentWidth.read(reader) - this._modifiedWidth.read(reader);
            const scroll2 = this._originalContentWidth.read(reader) - this._originalWidth.read(reader);
            if (scroll1 > scroll2) {
                return { maxScroll: scroll1, width: this._modifiedWidth.read(reader) };
            }
            else {
                return { maxScroll: scroll2, width: this._originalWidth.read(reader) };
            }
        });
        this._elements = h('div.multiDiffEntry', [
            h('div.content', {
                style: {
                    display: 'flex',
                    flexDirection: 'column',
                    flex: '1',
                    overflow: 'hidden',
                }
            }, [
                h('div.header@header', [
                    h('div.collapse-button@collapseButton'),
                    h('div.title.show-file-icons@title', []),
                    h('div.actions@actions'),
                ]),
                h('div.editorParent', {
                    style: {
                        flex: '1',
                        display: 'flex',
                        flexDirection: 'column',
                    }
                }, [
                    h('div.editorContainer@editor', { style: { flex: '1' } }),
                ])
            ])
        ]);
        this.editor = this._register(this._instantiationService.createInstance(DiffEditorWidget, this._elements.editor, {
            overflowWidgetsDomNode: this._overflowWidgetsDomNode,
        }, {}));
        this.isModifedFocused = isFocused(this.editor.getModifiedEditor());
        this.isOriginalFocused = isFocused(this.editor.getOriginalEditor());
        this.isFocused = derived(this, reader => this.isModifedFocused.read(reader) || this.isOriginalFocused.read(reader));
        this._resourceLabel = this._workbenchUIElementFactory.createResourceLabel
            ? this._register(this._workbenchUIElementFactory.createResourceLabel(this._elements.title))
            : undefined;
        this._dataStore = new DisposableStore();
        this._headerHeight = this._elements.header.clientHeight;
        const btn = new Button(this._elements.collapseButton, {});
        this._register(autorun(reader => {
            btn.element.className = '';
            btn.icon = this._collapsed.read(reader) ? Codicon.chevronRight : Codicon.chevronDown;
        }));
        this._register(btn.onDidClick(() => {
            var _a;
            (_a = this._viewModel.get()) === null || _a === void 0 ? void 0 : _a.collapsed.set(!this._collapsed.get(), undefined);
        }));
        this._register(autorun(reader => {
            this._elements.editor.style.display = this._collapsed.read(reader) ? 'none' : 'block';
        }));
        this.editor.getModifiedEditor().onDidLayoutChange(e => {
            const width = this.editor.getModifiedEditor().getLayoutInfo().contentWidth;
            this._modifiedWidth.set(width, undefined);
        });
        this.editor.getOriginalEditor().onDidLayoutChange(e => {
            const width = this.editor.getOriginalEditor().getLayoutInfo().contentWidth;
            this._originalWidth.set(width, undefined);
        });
        this._register(this.editor.onDidContentSizeChange(e => {
            globalTransaction(tx => {
                this._contentHeight.set(e.contentHeight, tx);
                this._modifiedContentWidth.set(this.editor.getModifiedEditor().getContentWidth(), tx);
                this._originalContentWidth.set(this.editor.getOriginalEditor().getContentWidth(), tx);
            });
        }));
        this._register(autorun(reader => {
            const isFocused = this.isFocused.read(reader);
            this._elements.root.classList.toggle('focused', isFocused);
        }));
        this._container.appendChild(this._elements.root);
        this._outerEditorHeight = 38;
        this._register(this._instantiationService.createInstance(MenuWorkbenchToolBar, this._elements.actions, MenuId.MultiDiffEditorFileToolbar, {
            actionRunner: this._register(new ActionRunnerWithContext(() => { var _a, _b; return ((_b = (_a = this._viewModel.get()) === null || _a === void 0 ? void 0 : _a.diffEditorViewModel) === null || _b === void 0 ? void 0 : _b.model.modified.uri); })),
            menuOptions: {
                shouldForwardArgs: true,
            }
        }));
    }
    setScrollLeft(left) {
        if (this._modifiedContentWidth.get() - this._modifiedWidth.get() > this._originalContentWidth.get() - this._originalWidth.get()) {
            this.editor.getModifiedEditor().setScrollLeft(left);
        }
        else {
            this.editor.getOriginalEditor().setScrollLeft(left);
        }
    }
    setData(data) {
        function updateOptions(options) {
            return {
                ...options,
                scrollBeyondLastLine: false,
                hideUnchangedRegions: {
                    enabled: true,
                },
                scrollbar: {
                    vertical: 'hidden',
                    horizontal: 'hidden',
                    handleMouseWheel: false,
                    useShadows: false,
                },
                renderOverviewRuler: false,
                fixedOverflowWidgets: true,
            };
        }
        const value = data.viewModel.entry.value; // TODO
        if (value.onOptionsDidChange) {
            this._dataStore.add(value.onOptionsDidChange(() => {
                var _a;
                this.editor.updateOptions(updateOptions((_a = value.options) !== null && _a !== void 0 ? _a : {}));
            }));
        }
        globalTransaction(tx => {
            var _a, _b;
            (_a = this._resourceLabel) === null || _a === void 0 ? void 0 : _a.setUri(data.viewModel.diffEditorViewModel.model.modified.uri);
            this._dataStore.clear();
            this._viewModel.set(data.viewModel, tx);
            this.editor.setModel(data.viewModel.diffEditorViewModel, tx);
            this.editor.updateOptions(updateOptions((_b = value.options) !== null && _b !== void 0 ? _b : {}));
        });
    }
    render(verticalRange, width, editorScroll, viewPort) {
        this._elements.root.style.visibility = 'visible';
        this._elements.root.style.top = `${verticalRange.start}px`;
        this._elements.root.style.height = `${verticalRange.length}px`;
        this._elements.root.style.width = `${width}px`;
        this._elements.root.style.position = 'absolute';
        // For sticky scroll
        const delta = Math.max(0, Math.min(verticalRange.length - this._headerHeight, viewPort.start - verticalRange.start));
        this._elements.header.style.transform = `translateY(${delta}px)`;
        globalTransaction(tx => {
            this.editor.layout({
                width: width,
                height: verticalRange.length - this._outerEditorHeight,
            });
        });
        this.editor.getOriginalEditor().setScrollTop(editorScroll);
        this._elements.header.classList.toggle('shadow', delta > 0 || editorScroll > 0);
    }
    hide() {
        this._elements.root.style.top = `-100000px`;
        this._elements.root.style.visibility = 'hidden'; // Some editor parts are still visible
    }
};
DiffEditorItemTemplate = __decorate([
    __param(3, IInstantiationService)
], DiffEditorItemTemplate);
export { DiffEditorItemTemplate };
function isFocused(editor) {
    return observableFromEvent(h => {
        const store = new DisposableStore();
        store.add(editor.onDidFocusEditorWidget(() => h(true)));
        store.add(editor.onDidBlurEditorWidget(() => h(false)));
        return store;
    }, () => editor.hasWidgetFocus());
}
